(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8350,        211]*)
(*NotebookOutlinePosition[      9036,        235]*)
(*  CellTagsIndexPosition[      8992,        231]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\(potencia[a_]\)[z_] := \(a^z\ \ \ \) (*\ 
      definimos\ la\ funci\[OAcute]n\ que\ ahora\ depende\ de\ un\ 
          par\[AAcute]metro\ a \[NotEqual] 0\ *) \ \)\)], "Input"],

Cell[BoxData[
    \(\(puntofijopotencia[a_] := 
      z /. FindRoot[a^z \[Equal] z, {z, Nest[potencia[a], 1.  + 1. \ I, 4]}, 
          \n\tMaxIterations \[Rule] 30]\ \)\)], "Input"],

Cell[BoxData[
    \(H[a_] := \(potencia[a]'\)[puntofijopotencia[a]]\)], "Input"],

Cell[CellGroupData[{

Cell["Ejercicios", "Section"],

Cell[TextData[{
  StyleBox["1",
    FontWeight->"Bold"],
  " Define una funci\[OAcute]n gr\[AAcute]fica, \"puntossucesion[a_, z_, n_, \
opts___]\",  que al ejecutarla muestre en pantalla los primeros n \
t\[EAcute]rminos de la sucesi\[OAcute]n  x[n+1]=a^x[n] con x[1]=z como puntos \
del plano unidos por segmentos. Elige un tama\[NTilde]o adecuado para los \
puntos y representa cada tres puntos consecutivos en colores rojo, verde y \
azul como hemos hecho antes. Centra el origen de coordenadas en el posible l\
\[IAcute]mite de la sucesi\[OAcute]n y p\[AAcute]sale las opciones \
gr\[AAcute]ficas a la funci\[OAcute]n que defines. \nSugerencias. Puede ser \
\[UAcute]til que primero definas una lista \"puntos[a_,z_,n_]\" a la que \
puedas aplicar las primitivas gr\[AAcute]ficas Point y Line."
}], "Text"],

Cell[TextData[{
  StyleBox["2",
    FontWeight->"Bold"],
  " ",
  StyleBox["a)",
    FontWeight->"Bold"],
  " Considera la siguiente lista de n\[UAcute]meros complejos. "
}], "Text"],

Cell[BoxData[
    \(\(valoresa = 
      Flatten[Table[x\  + \ y\ I, {x, 0. , 3, 0.25}, {y,  .5, 2.5, 0.25}]]; 
    \)\)], "Input"],

Cell[TextData[{
  "Construye a partir de ella una lista, \"puntosfijovaloresa\", cuyos \
elementos sean listas de la forma \n\t\t\t\t{a, puntofijopotencia[a], \
Abs[H[a]], Arg[H[a]]*180/N[\[Pi]]} \ndonde a\[Element]valoresa. \n\
Sugerencias. Todo lo que tienes que hacer es \"lanzar\" una funci\[OAcute]n, \
es f\[AAcute]cil imaginar cu\[AAcute]l, para que act\[UAcute]e sobre los \
elemtnso de la lista \"valoresa\". Recuerda el uso de #  y & para sustituir \
las variables as\[IAcute] como el comando /@.\n",
  StyleBox["b) ",
    FontWeight->"Bold"],
  "Selecciona los elementos de la lista \"puntosfijovaloresa\" para los que \
se verifica que Abs[H[a]]<.5. Estos valores de a son puntos fijos atractivos. \
Elije uno de ellos y un valor de z m\[AAcute]s o menos pr\[OAcute]ximo a \
\[EAcute]l para representar con el comando \"puntossucesion[a_, z_, n_, \
opts___]\"  los primeros 9 t\[EAcute]rminos de la sucesi\[OAcute]n \
correspondiente.\nSugerencia. Usa el comando \"Select[lista,cri",
  StyleBox["t]\" (consulta si es necesario la ayuda).",
    InitializationCell->True],
  "\nc",
  StyleBox[") ",
    FontWeight->"Bold"],
  "Selecciona los elementos de la lista \"puntosfijovaloresa\" para los que \
se verifica que Abs[H[a]]>1.3. Estos valores de a son puntos fijos \
repelentes. Elije uno de ellos y un valor de z m\[AAcute]s o menos \
pr\[OAcute]ximo a \[EAcute]l para representar con el comando \
\"puntossucesion[a_, z_, n_, opts___]\"  los primeros 9 t\[EAcute]rminos de \
la sucesi\[OAcute]n correspondiente.\n",
  StyleBox["d)",
    FontWeight->"Bold"],
  " Hemos visto que ",
  Cell[BoxData[
      \(TraditionalForm\`Arg[H[a]]\)]],
  " indica el \[AAcute]ngulo (en radianes) que cada t\[EAcute]rmino de la \
sucesi\[OAcute]n est\[AAcute] girado respecto del t\[EAcute]rmino anterior \
(con centro de giro en ",
  StyleBox["puntofijopotencia[a]",
    FontSlant->"Italic"],
  "). Selecciona los elementos de la lista \"puntosfijovaloresa\" para los \
que se verifica que 118<Arg[H[a]]<122. Elige dos de ellos, uno que sea un \
punto fijo atractivo y otro que sea un punto fijo repelente y elige valores \
adecuados de z para representar en cada caso los primeros 30 t\[EAcute]rminos \
de la sucesi\[OAcute]n correspondiente."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Soluciones", "Section"],

Cell[BoxData[{
    \(lista[a_, z_, n_] := N[NestList[potencia[a], z, n - 1]] (*\ 
      los\ primeros\ n\ t\[EAcute]rminos\ de\ la\ sucesi\[OAcute]n\ 
          x[n + 1] = \(a^x[n]\ con\ x[1] = z\)\ *) \), 
    \(puntos[a_, z_, n_] := 
      Transpose[{Re[lista[a, z, n]], Im[lista[a, z, n]]}]\  (*\ 
      pasamos\ a\ coordenadas\ cartesianas\ *) \), 
    \(colores[n_] := 
      Flatten[Table[{Hue[0], Hue[ .33], Hue[ .66]}, {k, 1, n/3}]]\), 
    \(\(grafica[a_, z_, n_, opts___] := 
      Show[Graphics[{
            Line[puntos[a, z, n]], {PointSize[ .015], 
              Transpose[{colores[n], Point/@puntos[a, z, n]}]}}], 
        AspectRatio \[Rule] 1, Axes \[Rule] True, 
        AxesOrigin 
          \[Rule] {Re[puntofijopotencia[a]], Im[puntofijopotencia[a]]}, 
        PlotRange \[Rule] All, opts]; \)\)}], "Input"],

Cell[BoxData[
    \(\(nuevalista = 
      \({#, puntofijopotencia[#], Abs[H[#]], Arg[H[#]]*180/N[\[Pi]]}&\)/@
        Flatten[Table[x\  + \ y\ I, {x, 0. , 3, 0.25}, {y,  .5, 2.5, 0.25}]]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(Select[nuevalista, #[\([3]\)] <  .5&] (*\ 
      son\ puntos\ fijos\ atractivos\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(grafica[ .75 +  .5\ I, I, 9, AspectRatio \[Rule] 1]\  (*\ 
      convergencia\ muy\ r\[AAcute]pida\ los\ puntos\ no\ se\ distinguen
        \ *) ; \)\)], "Input"],

Cell[BoxData[
    \(\(Select[nuevalista, #[\([3]\)] > \ 1.3&] (*\ 
      son\ puntos\ fijos\ repelentes\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(\(grafica[3.  +  .5\ I,  .5 + 1.1  I, 9]; 
    \) (*\ la\ sucesi\[OAcute]n\ diverge\ muy\ r\[AAcute]pidamente\ *) \)\)], 
  "Input"],

Cell[BoxData[
    \(Select[nuevalista, 118 < #[\([4]\)] < 122&]\)], "Input"],

Cell[BoxData[
    \(grafica[1.75\ \ I,  .4 +  .5  I, 90]\ ; \n
    Print["\<Se trata de un punto fijo repelente. No hay convergencia porque \
Abs[H[1.75 I]]=\>", Abs[H[1.75\ I]], 
      "\<y los puntos de igual color est\[AAcute]n casi alineados porque \
Arg[H[1.75 I]]*180/N[\[Pi]]=\>", Arg[H[1.75\ I]]*180/N[\[Pi]]]\)], "Input"],

Cell[BoxData[
    \(grafica[ .5\  + \ 1. \ I, I, 30]; \ \n
    Print["\<Se trata de un punto fijo atractivo. Hay convergencia porque \
Abs[H[.5+1. I]]=\>", Abs[H[ .5 + 1. \ I]], 
      "\<y los puntos de igual color est\[AAcute]n casi alineados porque \
Arg[H[.5+1. I]]*180/N[\[Pi]]=\>", Arg[H[ .5 + 1. \ I]]*180/N[\[Pi]]]\)], 
  "Input"],

Cell[BoxData[
    \(grafica[ .5 + 2. \ I,  .3 +  .4\ I, 90]\ ; 
    Print["\<Se trata de un punto fijo repelente. No hay convergencia porque \
Abs[H[.5+2.I]]=\>", Abs[H[ .5 + 2. \ I]], 
      "\<. La sucesi\[OAcute]n diverge muy lentamente\>"]\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 703}},
WindowSize->{1011, 707},
WindowMargins->{{2, Automatic}, {Automatic, 5}},
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 199, 3, 50, "Input"],
Cell[1911, 54, 182, 3, 70, "Input"],
Cell[2096, 59, 80, 1, 50, "Input"],

Cell[CellGroupData[{
Cell[2201, 64, 29, 0, 56, "Section"],
Cell[2233, 66, 810, 13, 98, "Text"],
Cell[3046, 81, 182, 7, 29, "Text"],
Cell[3231, 90, 130, 3, 50, "Input"],
Cell[3364, 95, 2256, 42, 341, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5657, 142, 29, 0, 56, "Section"],
Cell[5689, 144, 828, 16, 150, "Input"],
Cell[6520, 162, 208, 4, 50, "Input"],
Cell[6731, 168, 121, 2, 50, "Input"],
Cell[6855, 172, 184, 3, 50, "Input"],
Cell[7042, 177, 123, 2, 50, "Input"],
Cell[7168, 181, 154, 3, 50, "Input"],
Cell[7325, 186, 76, 1, 50, "Input"],
Cell[7404, 189, 330, 5, 90, "Input"],
Cell[7737, 196, 338, 6, 90, "Input"],
Cell[8078, 204, 256, 4, 70, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

